var cos = Math.cos
var sin = Math.sin

var gSPeople = new Array()
var gSPort = undefined
var gWindPower = 1
var gWindAngle = 0
var gWindChangeSpeed = 0
var gWindAngleDest = 0

///////////////////////////////////////////////////////////////////////////////////////////////

function SPersonNameToNumber(name)
{
	for (var i = 0; i < gSPeople.length; i++)
		{
			if (gSPeople[i].name == name) return i
		}
		
		return -1 
}

///////////////////////////////////////////////////////////////////////////////////////////////

function SGetPlayer()
{
	for (var i = 0; i < gSPeople.length; i++)
		{
			if (gSPeople[i].name == "player") return i
		}
}

///////////////////////////////////////////////////////////////////////////////////////////////

function SProcWind()
{
	if (gWindAngleDest+.1 >= gWindAngle && gWindAngleDest-.1 <= gWindAngle)
		{
			gWindChangeSpeed = Random(3,100)
			gWindAngleDest = Random(-4.6, 4.6)
			
		}

	if (Random(0,gWindChangeSpeed) == 2)
		{
			if (gWindAngle < gWindAngleDest)
				{
					gWindAngle += .1
				}
			else
				{
					gWindAngle -= .1
				}
		}


	//n = SGetPlayer()
	
	/*
	sin = a/c
	cos = b/c
	tan = a/b
	
	*/

	//x_velocity = ( gWindPower * cos (gWindAngle) ) 
	//y_velocity = ( gWindPower * sin (gWindAngle) )
}

function RenderWind()
{
	GetImage("comp.png").blit(250,10)
	Line(280,40, 280+( gWindPower * cos (gWindAngle) )*10, 40+( gWindPower * sin (gWindAngle) )*10, CreateColor(255,255,255) )

	//font.drawText(10,10,gWindAngle)
	//font.drawText(10,20,gWindAngleDest)
	//font.drawText(10,30,gWindChangeSpeed)
	font.drawText(10, 10, gSPeople[SGetPlayer()].anchor)
	
	if (gSPort != undefined)
		{
			p = gSPeople[SGetPlayer()]
			l = GetPersonLayer(p.name)
			font.drawText(MapToScreenX(l, GetPersonX(p.name)) - gSPort[2], MapToScreenY(l, GetPersonY(p.name)) - 16, gSPort[0])
		}
}

function SProcPeople()
{
	gSPort = undefined
	
	for (var i = 0; i < gSPeople.length; i++)
		{
		
			var name = gSPeople[i].name
			var x = Math.floor(GetPersonX(name) + 0.5)
			var y = Math.floor(GetPersonY(name) + 0.5)
			var layer = GetPersonLayer(name);
			
			///////////////////////////////////////////////////////////////////////////////////////////////
			
			//if (gSPeople[i].angle >= 6.5) gSPeople[i].angle = 0
			//if (gSPeople[i].angle <= -6.5) gSPeople[i].angle = 0
			
			SetPersonAngle(gSPeople[i].name, gSPeople[i].angle)
			
			var x_velocity = 0;
			var y_velocity = 0
			
			if (gSPeople[i].anchor == false)
				{
					x_velocity = ( ( 3 * cos (gSPeople[i].angle) ) + ( gWindPower * cos (gWindAngle) ) ) / 2
					y_velocity = ( ( 3 * sin (gSPeople[i].angle) )	+ ( gWindPower * sin (gWindAngle) ) ) / 2
				}
			
			///////////////////////////////////////////////////////////////////////////////////////////////	

			if (!IsPersonObstructed(name, GetPersonX(name)+x_velocity, GetPersonY(name)) && //FOR X
					GetPersonX(name)+x_velocity < GetLayerWidth(layer)*16 && 
					GetPersonX(name)+x_velocity > 0)
				{
					
					SetPersonX(name, GetPersonX(name)+x_velocity)
				}
			else
				{
					p = GetObstructingPerson(name, GetPersonX(name)+x_velocity, GetPersonY(name))
					if (p != "") 
						{
							n = PersonNameToNumber(p)
							if (n != -1) gSPeople[n].onTouch(gSPeople[i])
						}
				}
			if (!IsPersonObstructed(name, GetPersonX(name), GetPersonY(name)+y_velocity) &&  // FOR Y
					GetPersonY(name)+y_velocity < GetLayerHeight(layer)*16 && 
					GetPersonY(name)+y_velocity > 0)
				{				
					SetPersonY(name, GetPersonY(name)+y_velocity)
				}
			else
				{
					p = GetObstructingPerson(name, GetPersonX(name), GetPersonY(name)+y_velocity)
					if (p != "") 
						{
							n = PersonNameToNumber(p)
							if (n != -1) gSPeople[n].onTouch(gSPeople[i])
						}
				}			
				
			///////////////////////////////////////////////////////////////////////////////////////////////	
				
			if (i == SGetPlayer())
				{
					if (IsTriggerAt(x, y, layer))
						{
							ExecuteTrigger(x, y, layer);
							return
						}
						
					if (AreZonesAt(x, y, layer))
						{
							ExecuteZones(x, y, layer);
							return
						}
				}
				
			///////////////////////////////////////////////////////////////////////////////////////////////
		
			if (gSPeople[i].velocity > 0) QueuePersonCommand(name,COMMAND_ANIMATE,true)
		}
}

///////////////////////////////////////////////////////////////////////////////////////////////

function SProcInput()
{
	if (!gSuspendMovement)
		{
			n = SGetPlayer()
		
			while ( AreKeysLeft() )
				{
					switch (GetKey())
						{		
							case k_a:
								if (gSPeople[n].anchor == true)
									gSPeople[n].anchor = false
								else
									{ gSPeople[n].anchor = true; }					
							break;
						}
				}
				
			if (IsKeyPressed(k_left))
				{
					gSPeople[n].angle-=0.03125
				}		
				
			if (IsKeyPressed(k_right))
				{
					gSPeople[n].angle+=0.03125
				}		
		}
}

//////////////////////////////////////////////////////////////////////////////////
function SSetPort(name, map_name)
{
	gSPort = [name, map_name, font.getStringWidth(name) / 2]
}

///////////////////////////////////////////////////////////////////////////////////////////////

function oSPerson(name, onTouch, onUpdate)
{
	this.name = name
	this.angle = 0
	this.anchor = true
	
	this.onTouch = onTouch
	this.onUpdate = onUpdate
}

///////////////////////////////////////////////////////////////////////////////////////////////

function SwapShipMap(map, x, y)
{
	UProcList = new Array()
	RProcList = new Array()
	gSPeople = new Array()

	UProcList.push(UpdateMenus)
	RProcList.push(RenderMenus)			
	
	UProcList.push(SProcPeople)
	UProcList.push(SProcInput)
	UProcList.push(SProcWind)
	
	RProcList.push(RenderWind)
	
	ChangeMap(map)  
	
	AddPlayerShip(x, y)
}

///////////////////////////////////////////////////////////////////////////////////////////////

function AddPlayerShip(x, y)
{
	CreatePerson("player", PLAYER_SHIP_SPRITE, true)
	
	gSPeople.push( new oSPerson("player", DoNothing, DoNothing) )		
	
	SetPersonX("player", (x+1) * 7 )
	SetPersonY("player", (y+1) * 7 )
	
	AttachCamera("player")
}

///////////////////////////////////////////////////////////////////////////////////////////////

function CreateSPerson()
{
	gSPeople.push( new oSPerson(GetCurrentPerson(), DoNothing, DoNothing) )
}